/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWWorkBasketFilterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.queue.VWExposedFieldTableCellEditor;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketFilterTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.query.VWFieldListRenderer;
import filenet.vw.toolkit.utils.query.VWOperatorComboBoxRenderer;
import filenet.vw.toolkit.utils.table.VWDescriptionTableCellEditor;
import filenet.vw.toolkit.utils.table.VWDescriptionTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWWorkBasketFilterPanel
extends JPanel
implements IVWWizardPanel,
TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWWorkBasketDefinition m_workBasketDef = null;
    private VWToolbarBorder m_workBasketFiltersToolBar = null;
    private VWTable m_workBasketFilterTable = null;
    private VWWorkBasketFilterTableModel m_workBasketFilterTableModel = null;
    private VWExposedFieldTableCellEditor m_exposedFieldCellEditor = null;
    private JComboBox m_operatorListEditorCombo = null;

    public VWWorkBasketFilterPanel(VWSessionInfo sessionInfo) {
        this.createControls(sessionInfo);
        this.onSelectedWorkBasketFilter();
        this.setEnabled(false);
    }

    public void setEnabled(boolean bEnabled) {
        int nButtonState = 2;
        int nButtons = Integer.MAX_VALUE;
        this.m_workBasketFiltersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketFiltersToolBar.getClientPanel(), nButtonState, nButtons));
        if (bEnabled) {
            nButtonState = 1;
            nButtons = 16;
            if (this.m_workBasketFilterTable.getSelectedRow() != -1) {
                nButtons |= 0x10000040;
            }
            this.m_workBasketFiltersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketFiltersToolBar.getClientPanel(), nButtonState, nButtons));
        }
        this.m_workBasketFilterTable.setEnabled(bEnabled);
    }

    public void checkForErrors() throws Exception {
        this.stopEditing();
        if (this.m_workBasketDef == null) {
            return;
        }
        for (int nRowIndex = 0; nRowIndex < this.m_workBasketFilterTableModel.getRowCount(); ++nRowIndex) {
            VWWorkBasketFilterDefinition wbFilterDef = this.m_workBasketFilterTableModel.getRowItemAt(nRowIndex);
            if (wbFilterDef.getSearchField() == null) {
                throw new VWException("vw.toolkit.admin.property.queue.WorkBasketFilterHasNullSearchField", "In-basket ''{0}'' - filter ''{1}'' has an empty field value.", this.m_workBasketDef.getName(), wbFilterDef.getName());
            }
            if (wbFilterDef.getOperator() >= 0 && wbFilterDef.getOperator() <= 7) continue;
            throw new VWException("vw.toolkit.admin.property.queue.WorkBasketFilterHasInvalidOperator", "In-basket ''{0}'' - filter ''{1}'' has an invalid operator.", this.m_workBasketDef.getName(), wbFilterDef.getName());
        }
    }

    public String getHelpTopic() {
        return "filter_definition";
    }

    public String getUniqueIdentifier() {
        return "FILTER_DEFINITION";
    }

    public String getInstructions() {
        return VWResource.FilterDefinitionPanelInstructions;
    }

    public String getTitle() {
        return VWResource.FilterDefinitionPanelTitle;
    }

    public void initialize() throws Exception {
    }

    public void releaseResources() {
        if (this.m_workBasketFiltersToolBar != null) {
            this.m_workBasketFiltersToolBar.releaseResources();
            this.m_workBasketFiltersToolBar = null;
        }
        if (this.m_workBasketFilterTable != null) {
            this.m_workBasketFilterTable.removeAll();
            this.m_workBasketFilterTable = null;
        }
        if (this.m_workBasketFilterTableModel != null) {
            this.m_workBasketFilterTableModel.releaseResources();
            this.m_workBasketFilterTableModel = null;
        }
        this.m_workBasketDef = null;
        this.removeAll();
    }

    public boolean getDisplayState() {
        return true;
    }

    public void setDisplayState(boolean bState) {
    }

    public boolean getEnableFinishButton() {
        return true;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_workBasketFilterTable.getRowCount() - 1) {
                    nRow = this.m_workBasketFilterTable.getRowCount() - 1;
                }
                if (nRow == -1) {
                    return;
                }
                if (nRow == this.m_workBasketFilterTable.getSelectedRow()) {
                    this.m_workBasketFilterTable.clearSelection();
                }
                this.m_workBasketFilterTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
            case 0: {
                if (event.getColumn() != 1) break;
                this.updateOperatorCombo();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource().equals(this.m_workBasketFilterTable.getSelectionModel())) {
                this.onSelectedWorkBasketFilter();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.stopEditing();
            if (event.getSource() == this.m_workBasketFiltersToolBar) {
                switch (event.getID()) {
                    case 16: {
                        this.m_workBasketFilterTableModel.addNewWorkBasketFilter();
                        break;
                    }
                    case 64: {
                        int nRowIndex = this.m_workBasketFilterTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_workBasketFilterTableModel.copyWorkBasketFilterAtIndex(nRowIndex);
                        break;
                    }
                    case 0x10000000: {
                        int nRowIndex = this.m_workBasketFilterTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_workBasketFilterTableModel.deleteWorkBasketFilterAtIndex(nRowIndex);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setWorkBasketDefinition(VWWorkBasketDefinition workBasketDef) {
        try {
            this.m_workBasketDef = workBasketDef;
            if (this.m_workBasketDef == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.m_workBasketFilterTableModel.setWorkBasketDefinition(workBasketDef);
                this.m_exposedFieldCellEditor.setWorkBasketDefinition(workBasketDef);
                if (this.m_workBasketFilterTableModel.getRowCount() > 0) {
                    this.m_workBasketFilterTable.setRowSelectionInterval(0, 0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setQueueDefinition(VWQueueDefinition queueDef) {
        this.m_exposedFieldCellEditor.setQueueDefinition(queueDef);
    }

    protected boolean isModified() {
        this.stopEditing();
        if (this.m_workBasketFilterTableModel != null) {
            return this.m_workBasketFilterTableModel.isModified();
        }
        return false;
    }

    protected void resetModifiedFlag() {
        if (this.m_workBasketFilterTableModel != null) {
            this.m_workBasketFilterTableModel.resetModifiedFlag();
        }
    }

    protected void stopEditing() {
        if (this.m_workBasketFilterTable != null) {
            this.m_workBasketFilterTable.stopEditing();
        }
    }

    private void createControls(VWSessionInfo sessionInfo) {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            int nButtons = 0x10000050;
            this.m_workBasketFiltersToolBar = new VWToolbarBorder(VWResource.DefineInbasketFilters, nButtons, VWResource.DefineInbasketFiltersDescription);
            this.m_workBasketFiltersToolBar.setToolbarBackground(this.getBackground());
            this.m_workBasketFiltersToolBar.addToolbarBorderActionNotifier(this);
            VWAccessibilityHelper.setAccessibility(this.m_workBasketFiltersToolBar, this, VWResource.DefineInbasketFilters, VWResource.DefineInbasketFiltersDescription);
            JPanel childPanel = this.m_workBasketFiltersToolBar.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_workBasketFilterTableModel = new VWWorkBasketFilterTableModel(sessionInfo);
            this.m_workBasketFilterTableModel.addTableModelListener(this);
            this.m_workBasketFilterTable = new VWTable(this.m_workBasketFilterTableModel);
            this.m_workBasketFilterTable.setRowSelectionAllowed(true);
            this.m_workBasketFilterTable.getSelectionModel().setSelectionMode(0);
            this.m_workBasketFilterTable.getSelectionModel().addListSelectionListener(this);
            this.m_workBasketFilterTable.setRowHeight(26);
            this.m_workBasketFilterTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_workBasketFilterTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            VWAccessibilityHelper.setAccessibility(this.m_workBasketFilterTable, this, VWResource.InbasketFilterList, VWResource.InbasketFilterList);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.InbasketFilters), this.m_workBasketFilterTable);
            TableColumn tcElement = this.m_workBasketFilterTable.getColumnModel().getColumn(1);
            if (tcElement != null) {
                tcElement.setCellRenderer(new VWFieldListRenderer());
                this.m_exposedFieldCellEditor = new VWExposedFieldTableCellEditor(sessionInfo);
                tcElement.setCellEditor(this.m_exposedFieldCellEditor);
            }
            if ((tcElement = this.m_workBasketFilterTable.getColumnModel().getColumn(2)) != null) {
                tcElement.setCellRenderer(new VWOperatorComboBoxRenderer());
                this.m_operatorListEditorCombo = new JComboBox();
                this.m_operatorListEditorCombo.setRenderer(new VWOperatorComboBoxRenderer());
                tcElement.setCellEditor(new DefaultCellEditor(this.m_operatorListEditorCombo));
            }
            if ((tcElement = this.m_workBasketFilterTable.getColumnModel().getColumn(4)) != null) {
                tcElement.setPreferredWidth(60);
                tcElement.setCellRenderer(new VWDescriptionTableCellRenderer());
                tcElement.setCellEditor(new VWDescriptionTableCellEditor(sessionInfo, VWResource.ToolTip, VWResource.CreateToolTipHelperText));
            }
            childPanel.add((Component)new JScrollPane(this.m_workBasketFilterTable), "Center");
            this.add((Component)this.m_workBasketFiltersToolBar, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onSelectedWorkBasketFilter() {
        try {
            int nRowIndex = this.m_workBasketFilterTable.getSelectedRow();
            int nButtons = 0x10000040;
            if (nRowIndex == -1) {
                this.m_workBasketFiltersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketFiltersToolBar.getClientPanel(), 2, nButtons));
            } else {
                this.m_workBasketFiltersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketFiltersToolBar.getClientPanel(), 1, nButtons));
            }
            this.updateOperatorCombo();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateOperatorCombo() {
        try {
            VWExposedFieldDefinition fieldDef;
            DefaultComboBoxModel cbModel = new DefaultComboBoxModel();
            int nRowIndex = this.m_workBasketFilterTable.getSelectedRow();
            if (nRowIndex != -1 && (fieldDef = (VWExposedFieldDefinition)this.m_workBasketFilterTableModel.getValueAt(nRowIndex, 1)) != null) {
                cbModel = VWOperatorComboBoxRenderer.getComboBoxModel(fieldDef.getFieldType(), false);
            }
            this.m_operatorListEditorCombo.setModel(cbModel);
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.m_operatorListEditorCombo.setComponentOrientation(compOrientation);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

